﻿using System;
using System.Collections.Generic;
using System.Linq;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
    public partial class STD_COMBATLOCATIONDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors

        public STD_COMBATLOCATIONDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public STD_COMBATLOCATION GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        {
            STD_COMBATLOCATION objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_STD_COMBATLOCATION_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<STD_COMBATLOCATION> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<STD_COMBATLOCATION> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_STD_COMBATLOCATION_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        //public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, STD_COMBATLOCATION objSave)
        //{
        //    Int32? objReturn = objSave.ID;

        //    try
        //    {
        //        using (VIRPDBDataContext dbContext = GetDataContext())
        //        {
        //            LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //            dbContext.usp_STD_COMBATLOCATION_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.CODE, DateTime.Now, objSave.CREATEDBY, objSave.DESCRIPTION_TEXT, ref objReturn, objSave.INACTIVE_DATE, objSave.INACTIVE_FLAG, objSave.Name, objSave.SORT_ORDER, objSave.STD_REGISTRY_ID, DateTime.Now, objSave.UPDATEDBY, objSave.AUTO_CREATE);
        //            LogManager.LogTiming(logDetails);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //        throw ex;
        //    }

        //    return objReturn.GetValueOrDefault();
        //}

        //public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 ID)
        //{
        //    Boolean objReturn = false;

        //    try
        //    {
        //        using (VIRPDBDataContext dbContext = GetDataContext())
        //        {
        //            LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //            dbContext.usp_STD_COMBATLOCATION_delete(CURRENT_USER, CURRENT_REGISTRY_ID, ID);
        //            objReturn = true;
        //            LogManager.LogTiming(logDetails);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //        throw ex;
        //    }

        //    return objReturn;
        //}

        //public List<STD_COMBATLOCATION> GetItemsByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        //{
        //    List<STD_COMBATLOCATION> objReturn = null;

        //    try
        //    {
        //        using (VIRPDBDataContext dbContext = GetDataContext())
        //        {
        //            LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //            objReturn = dbContext.usp_STD_COMBATLOCATION_getitemsByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
        //            LogManager.LogTiming(logDetails);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
        //        throw ex;
        //    }

        //    return objReturn;
        //}

        #endregion
    }
}
